/*
 * Decompiled with CFR 0.152.
 */
package mlsoft.mct;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TextField;
import mlsoft.mct.MlGrid;
import mlsoft.mct.MlGridCellValues;
import mlsoft.mct.MlGridColumn;
import mlsoft.mct.MlGridDrawInfo;
import mlsoft.mct.MlGridRow;
import mlsoft.mct.MlUtil;

public class MlGridCell {
    public static final int SELECTED_BIT = 1;
    public static final int IN_ROWSPAN_BIT = 2;
    public static final int IN_COLSPAN_BIT = 4;
    protected MlGridCellValues _values;
    protected char _flags = '\u0000';
    protected Component _comp;
    protected String _string;
    Image _image;
    protected int _imageWidth = 0;
    protected int _imageHeight = 0;
    protected boolean _toggleState = false;

    public MlGridCellValues getValues() {
        return this._values;
    }

    public void setValues(MlGridCellValues mlGridCellValues) {
        this._values = mlGridCellValues;
    }

    public boolean inRowSpan() {
        return (this._flags & 2) > 0;
    }

    public boolean inColumnSpan() {
        return (this._flags & 4) > 0;
    }

    public boolean isSelected() {
        return (this._flags & '\u0001') > 0;
    }

    public void setInRowSpan(boolean bl) {
        this._flags = (char)(this._flags | 2);
        if (!bl) {
            this._flags = (char)(this._flags ^ 2);
        }
    }

    public void setInColumnSpan(boolean bl) {
        this._flags = (char)(this._flags | 4);
        if (!bl) {
            this._flags = (char)(this._flags ^ 4);
        }
    }

    public void setSelected(boolean bl) {
        this._flags = (char)(this._flags | '\u0001');
        if (!bl) {
            this._flags = (char)(this._flags ^ '\u0001');
        }
    }

    public void setComponent(Component component) {
        this._comp = component;
    }

    public Component getComponent() {
        return this._comp;
    }

    public void setString(String string) {
        this._string = string;
    }

    public String getString() {
        return this._string;
    }

    public void setToggle(boolean bl) {
        this._toggleState = bl;
    }

    public boolean getToggle() {
        return this._toggleState;
    }

    public void setImage(Image image, int n, int n2) {
        this._image = image;
        this._imageWidth = n;
        this._imageHeight = n2;
    }

    public Image getImage() {
        return this._image;
    }

    Dimension getImageDimensions() {
        return new Dimension(this._imageWidth, this._imageHeight);
    }

    public void draw(MlGridDrawInfo mlGridDrawInfo) {
        this.drawBackground(mlGridDrawInfo);
        this.drawValue(mlGridDrawInfo);
        this.drawBorders(mlGridDrawInfo);
    }

    public void drawBackground(MlGridDrawInfo mlGridDrawInfo) {
        Graphics graphics = mlGridDrawInfo.g;
        Rectangle rectangle = mlGridDrawInfo.clipRect;
        if (mlGridDrawInfo.drawSelected) {
            graphics.setColor(mlGridDrawInfo.selectBackground);
        } else {
            graphics.setColor(this._values.background);
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawBorders(MlGridDrawInfo mlGridDrawInfo) {
        Graphics graphics = mlGridDrawInfo.g;
        Rectangle rectangle = mlGridDrawInfo.cellRect;
        Rectangle rectangle2 = mlGridDrawInfo.clipRect;
        int n = rectangle2.x;
        int n2 = rectangle2.x + rectangle2.width - 1;
        int n3 = rectangle2.y;
        int n4 = rectangle2.y + rectangle2.height - 1;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        if (rectangle.x != rectangle2.x) {
            bl = false;
        }
        if (rectangle.x + rectangle.width != rectangle2.x + rectangle2.width) {
            bl2 = false;
        }
        if (rectangle.y != rectangle2.y) {
            bl4 = false;
        }
        if (rectangle.y + rectangle.height != rectangle2.y + rectangle2.height) {
            bl3 = false;
        }
        if (this._values.rightBorderType != 0 && bl2) {
            graphics.setColor(this._values.rightBorderColor);
            graphics.drawLine(n2, n3, n2, n4);
        }
        if (this._values.bottomBorderType != 0 && bl3) {
            graphics.setColor(this._values.bottomBorderColor);
            graphics.drawLine(n, n4, n2, n4);
        }
        if (this._values.topBorderType != 0 && bl4) {
            graphics.setColor(this._values.topBorderColor);
            graphics.drawLine(n, n3, n2, n3);
        }
        if (this._values.leftBorderType != 0 && bl) {
            graphics.setColor(this._values.leftBorderColor);
            graphics.drawLine(n, n3, n, n4);
        }
        if (mlGridDrawInfo.drawFocusType == 0) {
            return;
        }
        if (mlGridDrawInfo.drawFocusType == 2) {
            bl2 = false;
        } else if (mlGridDrawInfo.drawFocusType == 3) {
            bl = false;
        } else if (mlGridDrawInfo.drawFocusType == 4) {
            bl = false;
            bl2 = false;
        }
        int n5 = !bl ? 0 : 2;
        int n6 = !bl2 ? 0 : 2;
        if (mlGridDrawInfo.highlightThickness < 2) {
            return;
        }
        graphics.setColor(mlGridDrawInfo.highlightColor);
        if (bl4) {
            graphics.drawLine(n, n3, n2, n3);
        }
        if (bl) {
            graphics.drawLine(n, n3 + 2, n, n4);
        }
        if (bl2) {
            graphics.drawLine(n2, n3 + 2, n2, n4);
        }
        if (bl3) {
            graphics.drawLine(n + n5, n4, n2 - n6, n4);
        }
        if (bl4 && rectangle2.height > 1) {
            graphics.drawLine(n, n3 + 1, n2, n3 + 1);
        }
        if (bl3 && rectangle2.height > 1 && rectangle2.width > n6 && rectangle2.width > n5) {
            graphics.drawLine(n + n5, n4 - 1, n2 - n6, n4 - 1);
        }
        if (rectangle2.width > 1 && rectangle2.height > 2) {
            if (bl) {
                graphics.drawLine(n + 1, n3 + 2, n + 1, n4);
            }
            if (bl2) {
                graphics.drawLine(n2 - 1, n3 + 2, n2 - 1, n4);
            }
        }
    }

    public void drawValue(MlGridDrawInfo mlGridDrawInfo) {
        Graphics graphics = mlGridDrawInfo.g;
        MlGrid mlGrid = mlGridDrawInfo.grid;
        int n = this._values.leftMargin + this._values.rightMargin;
        int n2 = this._values.topMargin + this._values.bottomMargin;
        if (n >= mlGridDrawInfo.cellRect.width || n2 >= mlGridDrawInfo.cellRect.height) {
            return;
        }
        Rectangle rectangle = new Rectangle();
        rectangle.x = mlGridDrawInfo.cellRect.x + this._values.leftMargin;
        rectangle.y = mlGridDrawInfo.cellRect.y + this._values.topMargin;
        rectangle.width = mlGridDrawInfo.cellRect.width - n;
        rectangle.height = mlGridDrawInfo.cellRect.height - n2;
        if (this._values.type != 0 && this._image != null) {
            MlUtil.drawImage(graphics, this._image, mlGridDrawInfo.grid, this._imageWidth, this._imageHeight, this._values.alignment, rectangle, mlGridDrawInfo.clipRect);
            int n3 = this._imageWidth + 4;
            rectangle.x += n3;
            rectangle.width = n3 < rectangle.width ? (rectangle.width -= n3) : 0;
        }
        if (this._values.type != 1 && this._string != null) {
            if (mlGridDrawInfo.drawSelected) {
                graphics.setColor(mlGridDrawInfo.selectForeground);
            } else {
                graphics.setColor(this._values.foreground);
            }
            MlUtil.drawString(graphics, this._string, this._values.font, this._values.alignment, rectangle, mlGridDrawInfo.clipRect);
        }
        if (this._values.type == 3) {
            MlUtil.drawToggle(graphics, this._toggleState, mlGrid._toggleSize, 2, mlGrid._toggleBg, mlGrid._toggleTopShadowColor, mlGrid._toggleBotShadowColor, mlGrid._toggleFg, rectangle, mlGridDrawInfo.clipRect);
        }
        if (this._values.type == 4) {
            MlUtil.drawOption(graphics, this._toggleState, mlGrid._toggleSize, 2, mlGrid._toggleBg, mlGrid._toggleTopShadowColor, mlGrid._toggleBotShadowColor, mlGrid._toggleFg, rectangle, mlGridDrawInfo.clipRect);
        }
    }

    public void configureText(TextField textField, Rectangle rectangle) {
        int n = 0;
        int n2 = textField.getPreferredSize().height;
        if (n2 > rectangle.height) {
            n = n2 - rectangle.height;
        }
        textField.setBounds(rectangle.x - 3, rectangle.y - n / 2, rectangle.width + 6, rectangle.height + n);
    }

    public boolean isEditable() {
        return this._values.type == 0 && this._values.editable;
    }

    public int getPreferredHeight(MlGrid mlGrid, MlGridRow mlGridRow, MlGridColumn mlGridColumn, int n) {
        if (this._values.rowSpan > 0) {
            return 4;
        }
        int n2 = 0;
        if (this._values.type != 1) {
            n2 = n * this._values.fontHeight;
        }
        if (this._values.type != 0 && this._image != null && this._imageHeight > n2) {
            n2 = this._imageHeight;
        }
        if (this._values.type == 4 && n2 < mlGrid._optionSize) {
            n2 = mlGrid._optionSize;
        }
        if (this._values.type == 3 && n2 < mlGrid._toggleSize) {
            n2 = mlGrid._toggleSize;
        }
        return n2 += 4 + this._values.topMargin + this._values.bottomMargin;
    }

    public int getPreferredWidth(MlGrid mlGrid, MlGridRow mlGridRow, MlGridColumn mlGridColumn, int n) {
        if (this._values.columnSpan > 0) {
            return 4;
        }
        int n2 = 0;
        if (this._values.type != 1) {
            n2 += n * this._values.fontWidth;
        }
        if (this._values.type != 0 && this._image != null) {
            n2 += this._imageWidth;
        }
        if (this._values.type == 4) {
            n2 += mlGrid._optionSize;
        }
        if (this._values.type == 3) {
            n2 += mlGrid._toggleSize;
        }
        return n2 += 4 + this._values.leftMargin + this._values.rightMargin;
    }
}

